---
title: Best practices · Cloudflare One docs
description: By default, Magic Firewall permits all ingress traffic that has
  passed through Cloudflare's core DDoS mitigations. To proactively mitigate
  attacks and minimize your attack surface and leakage of attack traffic into
  your environment, we recommend implementing your Magic Firewall rules using
  the following guidelines.
lastUpdated: 2025-10-30T17:13:08.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/best-practices/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/best-practices/index.md
---

By default, Magic Firewall permits all ingress traffic that has passed through Cloudflare's core DDoS mitigations. To proactively mitigate attacks and minimize your attack surface and leakage of attack traffic into your environment, we recommend implementing your Magic Firewall rules using the following guidelines.

The best approach is to replicate your current ingress perimeter firewall rules in Magic Firewall. If you are unable to export your current perimeter firewall rules, contact your Implementation Manager for help translating the rules into Magic Firewall rules.

* [Minimal ruleset](https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/best-practices/minimal-ruleset/)
* [Extended ruleset](https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/best-practices/extended-ruleset/)
* [Magic Transit egress](https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/best-practices/magic-transit-egress/)
