---
title: Log in to Cloudflare · Cloudflare Fundamentals docs
description: Go to the Cloudflare dashboard and choose your sign-in option.
lastUpdated: 2025-10-14T16:41:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/user-profiles/login/
  md: https://developers.cloudflare.com/fundamentals/user-profiles/login/index.md
---

Go to the Cloudflare dashboard and choose your [sign-in option](#sign-in-options).

[Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

## Sign-in options

Cloudflare offers the following sign-in options:

### Email and password

Enter your email address and password.

### Single Sign-On (SSO)

If your admin has enabled [enabled SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/), enter your email address.

### Social login

Social login allows you to sign in with a trusted 3rd party sign in service such as Apple, Google, or GitHub. Social login is only available for accounts with a verified email address, or accounts that signed up via social login initially. If you have additionally configured two-factor authentication on your account, that will be presented in addition to any login and two-factor authentication provided by the social login provider.

Note

If you log in to your Cloudflare user account with Single Sign-On (SSO), you will not be able to use social login.

Warning

If you use social login to sign in, your user profile will not have a password associated with it at first. Some dashboard operations will require setting a password. To set a password, visit [Forgot Password](https://dash.cloudflare.com/forgot-password) in the Cloudflare dashboard.

#### Sign in with Apple

* **Same Cloudflare account email as Apple ID**: You can sign in with either your email and password or sign in with Apple.

* **Different Cloudflare account email as Apple ID**: This option creates a new Cloudflare account. If you want to log in to an existing account, [change your email address](https://developers.cloudflare.com/fundamentals/user-profiles/change-password-or-email/) to match the one used for your Apple ID.

If you chose to share your email when creating a Cloudflare account with Apple ID and want to set a password and obtain an API key, go to the [Cloudflare dashboard](https://dash.cloudflare.com/login) login page and select **Forgot your password?** to trigger a password reset email.

If you have chosen to hide your email when creating a Cloudflare account with Apple ID, resetting your password will not work. You can use the suggested workaround below:

1. [Add a new member to your account](https://developers.cloudflare.com/fundamentals/manage-members/manage/#add-account-members) using your secondary email address.
2. [Register a new Cloudflare account](https://developers.cloudflare.com/fundamentals/account/create-account/) with your secondary email address and set a password.
3. Access the Cloudflare dashboard with the new user and password to obtain an API key.

Changing your Cloudflare account email address will unlink the login credentials with the Apple ID from your Cloudflare account. If you attempt to log in using the same Apple ID after the email is changed, you will create a new Cloudflare account.

If you created your Cloudflare account using Apple Relay and decide to change your Apple ID or email address, you will be unable to retrieve the Cloudflare account and all login options will be permanently lost.

#### Sign in with Google

* **A Cloudflare account has already been created with your Google account's email**: This option is unavailable at this time, but we are working on the capability to link and unlink social login providers to your Cloudflare account.

* If you select **Sign in with Google** with an email that does not already have a Cloudflare account associated with it, Cloudflare will create a new account and allow you to sign in using **Sign in with Google** option moving forward.

#### Sign in with GitHub

* Sign in with GitHub uses the [Primary email address](https://docs.github.com/en/account-and-profile/how-tos/setting-up-and-managing-your-personal-account-on-github/managing-email-preferences/changing-your-primary-email-address) which is set on your GitHub account. If you change your primary email address in GitHub, you will not be able to log into your Cloudflare account using GitHub social login.

* If you select **Sign in with GitHub** with an email that does not already have a Cloudflare account associated with it, Cloudflare will create a new account and allow you to sign in using **Sign in with GitHub** option moving forward.
