---
title: Getting started with R2 · Cloudflare Learning Paths
description: >
  Cloudflare R2 is an object storage solution designed to handle your data and
  files efficiently. It is ideal for various use cases, such as storing large
  media files, creating data lakes, or delivering web assets. R2 offers a
  flexible architecture to suit your needs, all with zero egress fees, meaning
  you don't have to worry about unexpected costs when moving your data.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-1/
  md: https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-1/index.md
---

* Watch this episode

  Cloudflare R2 is an object storage solution designed to handle your data and files efficiently. It is ideal for various use cases, such as storing large media files, creating data lakes, or delivering web assets. R2 offers a flexible architecture to suit your needs, all with zero egress fees, meaning you don't have to worry about unexpected costs when moving your data.

  **Related content**

  If you want to dive into detail, refer to the following pages:

  * [Create new buckets](https://developers.cloudflare.com/r2/buckets/create-buckets/)
  * [Bucket-level operations](https://developers.cloudflare.com/r2/buckets/create-buckets/#bucket-level-operations)

* Series overview

  [Watch Episode 1: Getting started with R2 ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-1/)In this video, you'll learn how to use Cloudflare R2 to store and manage data with no egress fees, supporting use cases like media, web assets, backups, and static site hosting.

  [Watch Episode 2: Public buckets ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-2/)This video outlines how to configure public buckets in R2, which are private by default, to enable public Internet access. It presents two methods for setting up public access: using a custom domain or a Cloudflare managed subdomain.

  [Watch Episode 3: S3 API compatibility ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-3/)In this video, you'll learn how to use S3 API commands and tools with R2, set up and configure R2 for S3 API compatibility, and integrate R2 into your existing workflows with minimal changes.

  [Watch Episode 4: Migrating your bucket data ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-4/)In this video, you will learn how to use Cloudflare R2's data migration tools to transfer data from other cloud providers such as Amazon S3 and Google Cloud Storage to R2.

  [Watch Episode 5: Accessing your bucket from Cloudflare Workers ](https://developers.cloudflare.com/learning-paths/r2-intro/series/r2-5/)In this video, you will build a serverless file API using Cloudflare Workers and R2 by setting up a project, securing uploads, enabling caching, and deploying the application.
